from pydantic import BaseModel, Field
from typing import List, Optional
from datetime import datetime
import uuid

class CombinationRequest(BaseModel):
    names: List[str] = Field(..., min_items=2, max_items=10)
    category: Optional[str] = "general"
    userId: Optional[str] = None

class CombinationResult(BaseModel):
    combinations: List[str]
    metadata: dict

class CombinationRecord(BaseModel):
    id: str = Field(default_factory=lambda: str(uuid.uuid4()))
    originalNames: List[str]
    result: str
    category: str = "general"
    algorithm: str
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    userId: Optional[str] = None
    isPublic: bool = True
    popularity: int = 0

class PopularCombination(BaseModel):
    name: str
    originalNames: List[str]
    category: str
    count: int

class AnalyticsEvent(BaseModel):
    event: str
    data: dict
    sessionId: Optional[str] = None
    userId: Optional[str] = None
    timestamp: datetime = Field(default_factory=datetime.utcnow)